/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

Downloads_Obj = function() {
	/** GLOBAL VARS **/
	this.editors 				= new Array();
	this.userid					= 0;
	this.info 					= new Array();
	this.error					= '';
	
	/** UPLOAD PAGE VARS **/
	this.file_input_html 		= '<br /><input type="file" name="upload[]" />';
	this.mirror_input_html	= '<br /><input type="text" class="textbox" name="mirrors[]" value="http://" style="margin-top: 4px;" />';
	this.file_inputs 			= 1;
	this.do_upload				= true;
	this.private_opened 		= false;
	this.processing			= false;
	this.filelist					= new Array();
	
	/** DOWNLOADS PAGE VARS **/
	this.fileid 					= 0;
	this.commentid			= 0;
	this.popup_show			= false;
	
	/** MODCP PAGE VARS **/
	this.submenu_items 		= new Array();
	this.commentid			= 0;
	this.reportid				= 0;
	
	/**
	 * ################################
	 * GLOBAL FUNCTIONS
	 * ################################
	 **/
	this.global_init = function() {
		var tooltips = YAHOO.util.Dom.getElementsByClassName('tooltip');
		
		YAHOO.util.Event.on(tooltips, 'mouseenter', function(e) {
			alert('Hovered over a tooltip!');
		});
	};
	
	this.fetch_download_info = function(fileid) {
		if (fileid > 0) {
			var extraparams = '';
			
			extraparams += '&fileid=' + fileid;
			
			this.ajax_call('fetch_download_info', extraparams);
		}
	};
	
	/**
	 * ################################
	 * HOME PAGE
	 * ################################ 
	**/
	this.init_home_page = function(userid) {
		this.userid = userid;
		
		this.global_init();
	};
	
	/** 
	 * ################################
	 * UPLOADS 
	 * ################################
	**/
	this.init_upload_page = function() {
		
	};
	
	this.flash_upload = function() {
	

		if (this.processing == false) {
			var extraparams = '';
			
			var catid	    	= YAHOO.util.Dom.get('catid').value;
			var title	    	= YAHOO.util.Dom.get('title').value;
			var message     	= vB_Editor['vB_Editor_001'].get_editor_contents();
			var mirrors_enabled    	= YAHOO.util.Dom.get('mirrors_enabled').value;

//			if (mirrors_enabled == 'true')
//			{
//				var mirrors     	= YAHOO.util.Dom.getChildren('dbtech_downloads_mirrorinputs');
//			} else {
//				var mirrors     	= '';
//			}
			var priv 	    	= YAHOO.util.Dom.get('users');
			var pass	    	= YAHOO.util.Dom.get('password');
			var updating    	= YAHOO.util.Dom.get('updating').value;
			
			vB_Editor['vB_Editor_001'].prepare_submit(vB_Editor['vB_Editor_001'].get_editor_contents());
			
			extraparams += '&catid=' + catid;
			extraparams += '&title=' + PHP.urlencode(title);
			extraparams += '&message=' + PHP.urlencode(vB_Editor['vB_Editor_001'].get_editor_contents());
			
			if (priv != undefined) {
				extraparams += '&private=' + PHP.urlencode(priv.value);
			}
	
			if (pass != undefined) {
				extraparams += '&password=' + PHP.urlencode(pass.value);
			}
	
//			if ((mirrors.length > 0) && (typeof mirrors != 'undefined'))
//			{
//				for (var i in mirrors) {
//					if (mirrors[i].value != '' && mirrors[i].value != undefined && mirrors[i].value != 'http://' && mirrors[i].value != '//:http') {
//						extraparams += '&mirrors[' + i + ']=' + PHP.urlencode(mirrors[i].value);
//					}
//				}
//			}
	
			if (updating == 1) {
				extraparams += '&groupid=' + YAHOO.util.Dom.get('groupid').value;
			}
			
			extraparams += '&updating=' + updating;
			
			this.processing = true;
			
			
			if (typeof swfu == 'undefined')
			{
				return true;
			} else {
				this.ajax_call('flash_upload', extraparams);
				return false;
			}
		} else {
			alert("Current uploading...");
		}
	};
	
	this.add_input_file = function() {
		if (this.file_inputs < MAX_FILEINPUTS) {
			var file_input 		= YAHOO.util.Dom.get('dbtech_downloads_fileinput');
			var mirror_inputs	= YAHOO.util.Dom.get('dbtech_downloads_mirrorinputs');
			
			if (THIS_DOWNLOAD_PAGE != 'editing' && DO_MIRRORS == 1) {
				mirror_inputs.innerHTML += this.mirror_input_html;
			}
			
			this.file_inputs++;
			
			if (file_input != undefined) {
				YAHOO.util.Dom.get('fileinput_' + this.file_inputs).style.display = 'inline';
				
				if (this.file_inputs == MAX_FILEINPUTS) {
					var file_input_button = YAHOO.util.Dom.get('dbtech_downloads_fileinput_button');
					
					file_input_button.innerHTML = '';
				}
			}
		}
	};
	
	this.change_cat = function(catid, groupid) {
		if (groupid == 0) {
			window.location = THIS_PAGE + '.php?do=upload&catid=' + catid;
		} else {
			window.location = THIS_PAGE + '.php?do=editdownload&catid=' + catid + '&fileid=' + groupid;
		}
	};
	
	/**
	 * #########################
	 * Edit Download Page
	 * ######################### 
	 **/
	this.removefile = function(fileid) {
		var extraparams = '';
		
		extraparams += '&fileid=' + fileid;
		
		this.ajax_call('remove_file', extraparams);
	};
	
	this.change_cat_edit = function(fileid, catid) {
		window.location = THIS_PAGE + '.php?do=editdownload&fileid=' + fileid + '&catid=' + catid;
	};
	
	/**
	 * #########################
	 * Downloads Page
	 * ######################### 
	**/
	
	this.init_downloads_page = function(userid, fileid) {
		this.global_init();
		
		this.editors['favourites_added'] 	= YAHOO.util.Dom.get('favourites_add');
		this.editors['favourites_removed']	= YAHOO.util.Dom.get('favourites_remove');
		
		this.editors['comments-body'] = YAHOO.util.Dom.get('comments-body');
		this.editors['description-body'] = YAHOO.util.Dom.get('description-body');
		
		this.userid = userid;
		this.fileid = fileid;
	};
	
	this.delete_file = function(fileid) {
		var extraparams = '';
		
		extraparams += '&fileid=' + fileid;
		
		this.ajax_call('delete_file', extraparams);
		this.popup_overlay('downloads-overlay');
	};
	
	this.delete_comment = function() {
		var extraparams = '';
		
		extraparams += '&commentid=' + this.commentid;
		
		this.ajax_call('delete_comment', extraparams);
		this.popup_overlay('comment_delete-overlay');
	};
	
	this.delete_comment_pre = function(commentid) {
		this.commentid = commentid;
		
		this.popup_overlay('comment_delete-overlay');
	};
	
	this.toggle = function(what) {
		if (what == 'comments') {
			 var attributes = {
					 opacity: { to: 0 }
			 };
			
			var nodes = new Array('description-body');
			 
			var anim = new YAHOO.util.Anim(nodes, attributes, 1, YAHOO.util.Easing.easeOut); 
			
			anim.duration = 0.5;
			
			anim.onComplete.subscribe(function() {
				YAHOO.util.Dom.get('description-body').style.display = 'none';
				YAHOO.util.Dom.get('comments-table').style.opacity = 1;
				YAHOO.util.Dom.get('comments-body').style.display = 'inline';
				YAHOO.util.Dom.addClass('comment-tab', 'selected');
				YAHOO.util.Dom.removeClass('description-tab', 'selected');
			});
			
			anim.animate();
		} else if (what == 'description') {
			var attributes = {
					 opacity: { to: 0 }
			 };
			
			var nodes = new Array('comments-table');
			
			var anim = new YAHOO.util.Anim(nodes, attributes, 1, YAHOO.util.Easing.easeOut); 
			
			anim.duration = 0.5;
			
			anim.onComplete.subscribe(function() {
				YAHOO.util.Dom.get('comments-body').style.display = 'none';
				YAHOO.util.Dom.get('description-body').style.opacity = 1;
				YAHOO.util.Dom.get('description-body').style.display = 'inline';
				YAHOO.util.Dom.removeClass('comment-tab', 'selected');
				YAHOO.util.Dom.addClass('description-tab', 'selected');
			});
			
			anim.animate();
		}
	};
	
	this.commenthover = function(comment) {
		YAHOO.util.Dom.get('comment_modtools_' + comment).style.display = 'inline';
		
		var commentbody = YAHOO.util.Dom.get('comment_' + comment);
		
		this.info['commentcolor'] = commentbody.style.background;
		
		commentbody.style.border = '1px solid #D0D0D0';
		commentbody.style.background = '#F1F1F1';
	};
	
	this.commenthover_out = function(comment) {
		YAHOO.util.Dom.get('comment_modtools_' + comment).style.display = 'none';
		
		var commentbody = YAHOO.util.Dom.get('comment_' + comment);
		
		commentbody.style.border = 'none';
		commentbody.style.background = this.info['commentcolor'];
	};
	
	this.add_to_favourites = function() {
		extraparams = '';
		
		extraparams += '&userid=' + this.userid;
		
		extraparams += '&fileid=' + this.fileid;
		
		this.ajax_call('add_to_favourites', extraparams);
	};
	
	this.popup_overlay = function(contents) {
		if (this.popup_show == false) {
			YAHOO.util.Dom.get('overlay').innerHTML = YAHOO.util.Dom.get(contents).innerHTML;
			YAHOO.util.Dom.get('overlay').style.display = 'inline';
			
			var popup = new YAHOO.util.Motion('overlay', {
				points: {
		        	to: [400, 300]
		    	} 
			});
			
			popup.duration = 0.8;
			popup.method = YAHOO.util.Easing.backOut;
			
			this.popup_show = true;
			
			popup.animate();
		} else {
			var popup = new YAHOO.util.Motion('overlay', {
				points: {
		        	to: [10, 900]
		    	} 
			});

			popup.duration = 0.8;
			popup.method = YAHOO.util.Easing.backIn;
			
			popup.onComplete.subscribe(function() {
				YAHOO.util.Dom.get('overlay').style.display = 'none';
				YAHOO.util.Dom.get('overlay').innerHTML = '<span style="float: right;"><a href="javascript://" onclick="Downloads.popup_overlay(\'share-overlay\')"><img src="dbtech/downloads/images/colorpicker_close.png" /></a></span>';
			});
			
			this.popup_show = false;
			popup.animate();
		}
	};
	
	this.add_comment = function() {
		var comment = YAHOO.util.Dom.get('comment_input');
		
		var extraparams = '';
		
		extraparams += '&comment=' + PHP.urlencode(comment.value);
		extraparams += '&userid=' + this.userid;
		extraparams += '&fileid=' + this.fileid;
		
		this.popup_overlay('comments-overlay');
		this.ajax_call('add_comment', extraparams);
	};
	
	this.rate_download = function(type) {
		var extraparams = '';
		
		extraparams += '&userid=' + this.userid;
		extraparams += '&fileid=' + this.fileid;
		
		if (type == 1) {
			extraparams += '&type=1';
		} else {
			extraparams += '&type=0';
		}
		
		this.ajax_call('filerate', extraparams);
	};
	
	this.report_file = function() {
		var extraparams = '';
		var reason		= YAHOO.util.Dom.get('report_reason').value;
		
		extraparams += '&reason=' + reason;
		extraparams += '&targetid=' + this.fileid;
		extraparams += '&type=file';
		
		this.popup_overlay('report-overlay');
		this.ajax_call('report', extraparams);
	};
	
	this.report_comment = function() {
		var extraparams = '';
		var reason		= YAHOO.util.Dom.get('report_comment_reason').value;
		
		extraparams += '&reason=' + reason;
		extraparams += '&targetid=' + this.commentid;
		extraparams += '&type=comment';
		
		this.popup_overlay('report-overlay');
		this.ajax_call('report', extraparams);
	};
	
	this.report_comment_pre = function(commentid) {
		this.commentid = commentid;
		
		this.popup_overlay('reportcomment-overlay');
	};
	
	this.report_link_broken = function(link) {
		link = PHP.trim(PHP.urlencode(link));
		
		var extraparams = '';
		
		extraparams += '&link=' + link;
		
		extraparams += '&target=' + this.fileid;
		
		this.ajax_call('report_link', extraparams);
	};
	
	/**
	 * #########################
	 * UPLOAD PAGE
	 * #########################
	 **/
	
	/**
	 * #########################
	 * MODCP
	 * ######################### 
	 **/
	this.mod_toggle = function(what) {
		if (what == 'reports') {
			 var attributes = {
					 opacity: { to: 0 }
			 };
			
			var anim = new YAHOO.util.Anim('queue', attributes, 0.5, YAHOO.util.Easing.easeOut); 
			
			anim.onComplete.subscribe(function() {
				YAHOO.util.Dom.get('queue').style.display = 'none';
				YAHOO.util.Dom.get('reports').style.opacity = 1;
				YAHOO.util.Dom.get('reports').style.display = 'inline-table';
				YAHOO.util.Dom.addClass('reports-link', 'selected');
				YAHOO.util.Dom.removeClass('queue-link', 'selected');		
			});
			
			anim.animate();
		} else {
			var attributes = {
					 opacity: { to: 0 }
			 };
			
			var anim = new YAHOO.util.Anim('reports', attributes, 0.5, YAHOO.util.Easing.easeOut); 
			
			anim.onComplete.subscribe(function() {
				YAHOO.util.Dom.get('reports').style.display = 'none';
				YAHOO.util.Dom.get('reports').style.opacity = 1;
				YAHOO.util.Dom.get('queue').style.display = 'inline-table';
				YAHOO.util.Dom.removeClass('reports-link', 'selected');
				YAHOO.util.Dom.addClass('queue-link', 'selected');
			});
			
			anim.animate();
		}
	};
	
	this.premanage = function(popup, fileid, commentid, reportid) {
		this.fileid 			= fileid;
		this.commentid 	= commentid;
		this.reportid 		= reportid;
		
		this.popup_overlay(popup);
	};
	
	this.manage_report = function(reportid) {
		var extraparams = '';
		
		extraparams += '&reportid=' + reportid;
		
		this.ajax_call('get_report', extraparams);
	};
	
	this.submit_report = function(type) {
		var extraparams = '';
		
		extraparams += '&type=' + type;
		
		extraparams += '&fileid=' + this.fileid;
		
		extraparams += '&commentid=' + this.commentid;
		
		extraparams += '&reportid=' + this.reportid;
		
		this.ajax_call('handle_report', extraparams);
		
		this.popup_overlay('reports');
	};
	
	this.moderate_file = function(type, fileid) {
		var extraparams = '';
		
		extraparams += '&fileid=' + fileid;
		
		extraparams += '&type=' + type;
		
		this.ajax_call('moderate_file', extraparams);
	};
	
	/**
	 * #########################
	 * HOME PAGE
	 * ######################### 
	**/	
	
	this.quick_search = function(term) {
		var extraparams = '';
		
		var title 	= YAHOO.util.Dom.get('title_search').value;
		var author	= YAHOO.util.Dom.get('author_search').value;
		
		if (title == 'on') {
			title = 1;
		} else {
			title = 0;
		}
		
		if (author == 'on') {
			author = 1;
		} else {
			author = 0;
		}
		
		extraparams += '&term=' + PHP.urlencode(term);
		extraparams += '&type=quick';
		extraparams += '&author=' + author;
		extraparams += '&title=' + title;
		
		if (term.length >= 3) {
			this.ajax_call('search', extraparams);
			
			this.global_init();
		} else {
			return false;
		}
	};
		
	/**
	 * #########################
	 * AJAX STUFF
	 * #########################
	**/
	
	this.ajax_completed = function(ajax) {
		if (!ajax.responseXML) {
			this.throw_ajax_error('Invalid response from server: ' + ajax.responseText);
			return false;
		}

		var error = ajax.responseXML.getElementsByTagName('error');

		if (error.length) {
			this.throw_ajax_error(error[0].firstChild.nodeValue);
		} else {
			var tags = [ 'catid', 'flashid', 'moderateid', 'reportid', 'comment_deletedid', 'deleted', 'deleteid', 'deletestatus', 'ratingtype', 'comment', 'success', 'favourites', 'search', 'fileid', 'searchdesc', 'author', 'authorid', 'tooltipname', 'bbhash', 'bbuser', 'tooltipdesc', 'tooltipimg' ];
			for ( var t = 0; t < tags.length; t++) {
				eval('var ' + tags[t]
						+ ' = ajax.responseXML.getElementsByTagName("'
						+ tags[t] + '");');
			}
			
			if (flashid.length && catid.length) {
				var groupid = flashid[0].firstChild.nodeValue;
				var catid	= catid[0].firstChild.nodeValue;

				if (typeof swfu != 'undefined')
				{
					swfu.addPostParam('groupid', groupid);
					swfu.addPostParam('catid', catid);
					
					if (swfu.getStats().files_queued === 0) {
						if (this.do_upload == true) {
							this.processing = false;
							
							window.location = THIS_PAGE + '.php?do=getlastdownload';
						}
					} else {
						swfu.startUpload();
					}
				}
				else 
				{
					YAHOO.util.Dom.get('groupid').innerHTML		= '<input type="hidden" name="groupid" id="groupid" value="'+groupid+'" />';
					document.vbform.submit();
				}
			}
			
			if (moderateid.length) {
				var mod = YAHOO.util.Dom.get('moderate_' + moderateid[0].firstChild.nodeValue);
				
				var attributes = {
						 opacity: { to: 0 }
				 };
				
				var anim = new YAHOO.util.Anim('moderate_' + moderateid[0].firstChild.nodeValue, attributes, 1, YAHOO.util.Easing.easeOut); 
				
				anim.onComplete.subscribe(function() {
					mod.innerHTML = '';
				});
				
				anim.animate();
			}
			
			if (reportid.length) {
				var report = YAHOO.util.Dom.get('report_' + reportid[0].firstChild.nodeValue);
				
				var attributes = {
						 opacity: { to: 0 }
				 };
				
				var anim = new YAHOO.util.Anim('report_' + reportid[0].firstChild.nodeValue, attributes, 1, YAHOO.util.Easing.easeOut); 
				
				anim.onComplete.subscribe(function() {
					report.innerHTML = '';
				});
				
				anim.animate();
			}
			
			if (comment_deletedid.length) {
				var comment = YAHOO.util.Dom.get('comment_' + comment_deletedid[0].firstChild.nodeValue);
				
				var attributes = {
						 opacity: { to: 0 }
				 };
				
				var anim = new YAHOO.util.Anim('comments_' + comment_deletedid[0].firstChild.nodeValue, attributes, 1, YAHOO.util.Easing.easeOut); 
				
				anim.onComplete.subscribe(function() {
					comment.innerHTML = '';
				});
				
				anim.animate();
			}
			
			if (deleted.length) {
				if (deleted[0].firstChild.nodeValue == '1') {
					window.location = THIS_PAGE + '.php';
				}
			}
			
			if (deletestatus.length) {
				if (deletestatus[0].firstChild.nodeValue == '1') {
					YAHOO.util.Dom.get('currentfile_' + deleteid[0].firstChild.nodeValue).innerHTML = '';

					MAX_FILEINPUTS = MAX_FILEINPUTS + 1;

					if (typeof swfu != 'undefined') {
						swfu.setFileUploadLimit(MAX_FILEINPUTS);
						swfu.setFileQueueLimit(MAX_FILEINPUTS);
					}
				}
			}
			
			if (ratingtype.length) {
				var rating = YAHOO.util.Dom.get('rating');
				
				if (ratingtype[0].firstChild.nodeValue == 'minus' && (parseInt(rating.innerHTML) - 1) == 0) {
					YAHOO.util.Dom.get('ratingsign').innerHTML 		= '';
					YAHOO.util.Dom.get('ratingsign').style.color 	= 'gray';
					rating.style.color 								= 'gray';
				} else if (ratingtype[0].firstChild.nodeValue == 'plus' && (parseInt(rating.innerHTML) == 0)) {
					YAHOO.util.Dom.get('ratingsign').innerHTML		= '+';
					YAHOO.util.Dom.get('ratingsign').style.color 	= 'green';
					rating.style.color 								= 'green';
				} else if (ratingtype[0].firstChild.nodeValue == 'minus' && parseInt(rating.innerHTML) == 0) {
					YAHOO.util.Dom.get('ratingsign').style.color 	= 'red';
					rating.style.color 								= 'red';
				}
				
				if (ratingtype[0].firstChild.nodeValue == 'plus') {
					rating.innerHTML = parseInt(rating.innerHTML) + 1;
				} else {
					rating.innerHTML = parseInt(rating.innerHTML) - 1;
				}
				console.info("Rating Successful");
				YAHOO.util.Dom.get('ratingcontrols').innerHTML = '';
			}
			
			if (comment.length) {
				if (success.length && success[0].firstChild.nodeValue == 'yes') {
					var commenttable = YAHOO.util.Dom.get('comments-table');
					
					commenttable.innerHTML = comment[0].firstChild.nodeValue + commenttable.innerHTML;
					
					this.toggle('comments');
				}
			}
			
			if (favourites.length) {
				var favour = YAHOO.util.Dom.get('favourites');
				if (favourites[0].firstChild.nodeValue == 'added') {
					this.editors['favourites_added'].style.display	 	= 'none';
					this.editors['favourites_removed'].style.display 	= 'inline';
					
					favour.innerHTML = parseInt(favour.innerHTML) + 1;
				} else {
					this.editors['favourites_added'].style.display	 	= 'inline';
					this.editors['favourites_removed'].style.display 	= 'none';
					
					favour.innerHTML = parseInt(favour.innerHTML) - 1;
				}
			}
			
			if (search.length) {
				var holder = YAHOO.util.Dom.get('search_results_holder');
				var results = YAHOO.util.Dom.get('search_results');
				
				var coords_x = YAHOO.util.Dom.getX('searchbox');
				var coords_y = YAHOO.util.Dom.getY('searchbox');
				
				this.global_init();
				
				coords_y = coords_y + 23;
				
				holder.style.display = 'inline';
				results.innerHTML = '';
				
				YAHOO.util.Dom.setX('search_results_holder', coords_x);
				YAHOO.util.Dom.setY('search_results_holder', coords_y);
				
				YAHOO.util.Event.on(document.body, "click", function(e) {
					holder.style.display = 'none';
					results.innerHTML = '';
				}); 
				
				for(i=0; i<=search.length; i++) { 
					if (VBVERSION == 4) {
						results.innerHTML += '<div class="tr blockbody">' + 
						'<div class="td blockrow" style="width; 10%;"><a class="tooltip" href="' + THIS_PAGE + '.php?do=download&amp;fileid=' + fileid[i].firstChild.nodeValue + '">' + search[i].firstChild.nodeValue + '</a></div>' +
						'<div class="td blockrow">' + searchdesc[i].firstChild.nodeValue + '</div>' + 
						'<div class="td blockrow" style="width: 10%;"><a href="member.php?u=' + authorid[i].firstChild.nodeValue + '">' + author[i].firstChild.nodeValue + '</a></div>' + 
						'</div>';
					} else {
						results.innerHTML += '<tr>' + 
						'<td style="width; 10%;"><a class="tooltip" href="' + THIS_PAGE + '.php?do=download&amp;fileid=' + fileid[i].firstChild.nodeValue + '">' + search[i].firstChild.nodeValue + '</a></td>' +
						'<td>' + searchdesc[i].firstChild.nodeValue + '</td>' + 
						'<td style="width: 10%;"><a href="member.php?u=' + authorid[i].firstChild.nodeValue + '">' + author[i].firstChild.nodeValue + '</a></div>' + 
						'</tr>';
					}
				}
			}
			
			if (tooltipname.length) {
				var tooltip = YAHOO.util.Dom.get('tooltip');
				
				alert(tooltip);
			}
		}
	};

	this.ajax_call = function(varname, extraparams) {
		return YAHOO.util.Connect.asyncRequest('POST', 'ajax.php', {
			success : this.ajax_completed,
			failure : this.handle_ajax_error,
			timeout : vB_Default_Timeout,
			scope : this
		}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&do=dbtech_downloads_'
				+ varname + extraparams);
	};
	
	this.throw_ajax_error = function(error) {
		console.error(this.timestamp() + "AJAX Error: %s", error);
		
		this.error = error;
		
		alert(error);
	};

	this.handle_ajax_error = function(ajax) {
		if (ajax.statusText == 'communication failure'
				|| ajax.statusText == 'transaction aborted') {
			return false;
		}

		console.error(this.timestamp() + "AJAX Error: Status = %s: %s",
				ajax.status, ajax.statusText);
		
		this.error = ajax.statusText;
		
		alert(ajax.statusText);
	};

	this.timestamp = function() {
		var d = new Date();

		return '[' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds()
				+ '] ';
	};
};